/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import java.util.Calendar;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.service.VoidServiceResponse;

import junit.framework.TestCase;

import gov.va.med.mhv.core.service.delegate.EmailServiceDelegate;
import gov.va.med.mhv.core.util.MessagesStringBuilder;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.util.HelpDeskAlert;
import gov.va.med.mhv.usermgmt.util.HelpDeskAlertProperties;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public class HelpdeskAlerterTest extends TestCase {
    
    private static final Log LOG = LogFactory.getLog(HelpdeskAlerterTest.class);

    private HelpDeskAlert alert = null;
    private Patient fromPatient = null;
    private Patient toPatient = null;
        
    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        alert = createTestAlert();
        fromPatient = createFromPatient();
        assertNotNull(fromPatient);
        assertNotNull(fromPatient.getInvalidatedIcn());
        assertNotNull(fromPatient.getInvalidationReferenceId());
        assertNotNull(fromPatient.getUserProfile());
        assertNotNull(fromPatient.getUserProfile().getMhvId());
        toPatient = createToPatient();
        assertNotNull(toPatient);
        assertNotNull(toPatient.getIcn());
        assertNotNull(toPatient.getUserProfile());
        assertNotNull(toPatient.getUserProfile().getMhvId());
        assertNotNull(toPatient);
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        alert = null;
        fromPatient = null;
        toPatient = null;
        super.tearDown();
    }

    /*
     * Test method for 'gov.va.med.mhv.usermgmt.util.HelpdeskAlerter.
     * sendMergeAlert(Patient, Patient)'
     */
    public void testCreateMergeAlert() {
        LOG.debug("from: " + alert.getSender());
        assertEquals(HelpDeskAlertProperties.getInstance().
            getHelpDeskEmailAddress(), alert.getSender());
        LOG.debug("to: " + alert.getRecipient());
        assertEquals(HelpDeskAlertProperties.getInstance().
            getHelpDeskEmailAddress(), alert.getRecipient());
        LOG.debug("reply-to: " + alert.getRecipient());
        assertEquals(HelpDeskAlertProperties.getInstance().
            getHelpDeskEmailAddress(), alert.getReplyTo());
        LOG.debug("subject: " + alert.getSubject());
        String expectedSubject = "MPI merge request (reference: "
            + fromPatient.getInvalidationReferenceId() + ")";
        assertEquals(expectedSubject, alert.getSubject());
        LOG.debug("message:\n" + alert.getMessage());
        String expectedMessagePrefix = "The MPI system requested the " +
            "following ICNs to be merged:\r\n" +
            "  Source ICN: " + fromPatient.getInvalidatedIcn() + "\r\n" +
            "  Target ICN: " + toPatient.getIcn() + "\r\n" + 
            "  Request Time:";
        assertStartsWith(expectedMessagePrefix, alert.getMessage());
        //%3$tA %3$tB %3$te, %3$tY %3$tH:%3$tM %3$Tp%n%n" +
        String expectedMessagePostfix = 
            "MHV has two different accounts for these ICNs:\r\n" +
            "  Source account with MHV-ID " 
            + fromPatient.getUserProfile().getMhvId() + "\r\n" +
            "  Target account with MHV-ID " 
            + toPatient.getUserProfile().getMhvId() +"\r\n\r\n" +
            "Access to this source account has been disabled.\r\n\r\n" +
            "Reference ID for this request is " + 
            fromPatient.getInvalidationReferenceId() + "\r\n\r\n";        
        assertEndsWith(expectedMessagePostfix, alert.getMessage());
    }
    
    public void xxxSendMessageAlert() {
        LOG.debug("recipient: " + alert.getRecipient());
        LOG.debug("subject: " + alert.getSubject());
        LOG.debug("message: " + alert.getMessage());
        VoidServiceResponse response = alert.send();
        assertFalse((new MessagesStringBuilder()).append(response.
            getMessages(), EmailServiceDelegate.class).toString(), 
            response.getMessages().hasErrorMessages());
    }
    
    private static HelpDeskAlert createTestAlert() {
        Patient fromPatient = TransferObjectFactory.createPatient();
        fromPatient.setInvalidatedIcn("012345testVdummy01");
        fromPatient.setInvalidationReferenceId("20080214-0987");
        fromPatient.setUserProfile(TransferObjectFactory.createUserProfile());
        fromPatient.getUserProfile().setMhvId("12345-6789-0001");

        Patient toPatient = TransferObjectFactory.createPatient();
        toPatient.setIcn("o12345testVdummy02");
        toPatient.setUserProfile(TransferObjectFactory.createUserProfile());
        toPatient.getUserProfile().setMhvId("12345-6789-0002");
        
        HelpDeskAlert alert = HelpDeskAlertProperties.getInstance().
            createMergePatientsAlert();
        alert.formatSubject(fromPatient.getInvalidationReferenceId());
        alert.formatMessage(fromPatient.getInvalidatedIcn(), toPatient.getIcn(), 
            Calendar.getInstance(), fromPatient.getUserProfile().getMhvId(), 
            toPatient.getUserProfile().getMhvId(), fromPatient.
            getInvalidationReferenceId());
        return alert;
    }

    private static Patient createFromPatient() {
        Patient fromPatient = TransferObjectFactory.createPatient();
        fromPatient.setInvalidatedIcn("012345testVdummy01");
        fromPatient.setInvalidationReferenceId("20080214-0987");
        fromPatient.setUserProfile(TransferObjectFactory.createUserProfile());
        fromPatient.getUserProfile().setMhvId("12345-6789-0001");
        return fromPatient;
    }
    
    private static Patient createToPatient() {
        Patient toPatient = TransferObjectFactory.createPatient();
        toPatient.setIcn("o12345testVdummy02");
        toPatient.setUserProfile(TransferObjectFactory.createUserProfile());
        toPatient.getUserProfile().setMhvId("12345-6789-0002");
        return toPatient;
    }
    
    private void assertStartsWith(String expected, String value) {
        if ((expected == null) && (value == null)) {
            return;
        }
        assertNotNull(expected);
        assertNotNull(value);
        if (!value.startsWith(expected)) {
            fail("Expected string starting with \n[" + expected 
                + "], but got \n[" + value.substring(0, expected.length()) + "]");
        }
    }

    private void assertEndsWith(String expected, String value) {
        if ((expected == null) && (value == null)) {
            return;
        }
        assertNotNull(expected);
        assertNotNull(value);
        if (!value.endsWith(expected)) {
            fail("Expected string ending with \n[" + expected 
                + "], but got \n[" + value.substring(value.length()) + "]");
        }
    }
}
